"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.commandUpdateTo = exports.commandStopFiltering = exports.commandStartFiltering = exports.commandSetLicenseExpirationTimestamp = exports.commandSetWhitelistedDomains = exports.commandSetBlockedCategories = exports.commandActivateNativeService = void 0;
var content_filtering_native_api_1 = require("./content-filtering-native-api");
var commandActivateNativeService = function () { return ({
    commandName: content_filtering_native_api_1.CommandNames.activateNativeService,
    payload: {},
}); };
exports.commandActivateNativeService = commandActivateNativeService;
var commandSetBlockedCategories = function (categories) { return ({
    commandName: content_filtering_native_api_1.CommandNames.setBlockedCategories,
    payload: { categories: categories },
}); };
exports.commandSetBlockedCategories = commandSetBlockedCategories;
var commandSetWhitelistedDomains = function (domains) { return ({
    commandName: content_filtering_native_api_1.CommandNames.setWhitelistedDomains,
    payload: { domains: domains },
}); };
exports.commandSetWhitelistedDomains = commandSetWhitelistedDomains;
var commandSetLicenseExpirationTimestamp = function (date) { return ({
    commandName: content_filtering_native_api_1.CommandNames.setLicenseExpirationTimestamp,
    payload: { licenseExpirationTimestamp: Math.floor(date.getTime() / 1000) },
}); };
exports.commandSetLicenseExpirationTimestamp = commandSetLicenseExpirationTimestamp;
var commandStartFiltering = function () { return ({
    commandName: content_filtering_native_api_1.CommandNames.startFiltering,
    payload: {},
}); };
exports.commandStartFiltering = commandStartFiltering;
var commandStopFiltering = function () { return ({
    commandName: content_filtering_native_api_1.CommandNames.stopFiltering,
    payload: {},
}); };
exports.commandStopFiltering = commandStopFiltering;
var commandUpdateTo = function (updateFilePath) { return ({
    commandName: content_filtering_native_api_1.CommandNames.updateTo,
    payload: { updateFilePath: updateFilePath },
}); };
exports.commandUpdateTo = commandUpdateTo;
